/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player.companion;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionStats;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.constants.EnumCompanionTalent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;
import org.lwjgl.input.Mouse;

public class GuiNpcCompanionTalents
extends GuiNPCInterface {
    private long lastPressedTime = 0L;
    private final RoleCompanion role;
    private GuiNpcButton selected;
    private long startPressedTime = 0L;
    private Map<Integer, GuiTalent> talents = new HashMap<Integer, GuiTalent>();

    public GuiNpcCompanionTalents(EntityNPCInterface npc) {
        super(npc);
        this.role = (RoleCompanion)npc.advanced.roleInterface;
        this.closeOnEsc = true;
        this.setBackground("companion_empty.png");
        this.xSize = 171;
        this.ySize = 166;
    }

    @Override
    public void func_146284_a(@Nonnull GuiButton guibutton) {
        super.func_146284_a(guibutton);
        int id = guibutton.field_146127_k;
        if (id == 1) {
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.Companion);
        }
        if (id == 3) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.CompanionOpenInv, new Object[0]);
        }
        if (id >= 10) {
            long getWorldTime;
            this.selected = (GuiNpcButton)guibutton;
            this.startPressedTime = getWorldTime = this.field_146297_k.field_71441_e.func_72820_D();
            this.lastPressedTime = getWorldTime;
            this.addExperience(1);
        }
    }

    private void addExperience(int exp) {
        EnumCompanionTalent talent = this.talents.get(this.selected.field_146127_k - 10).talent;
        if (!this.role.canAddExp(-exp) && this.role.currentExp <= 0) {
            return;
        }
        if (exp > this.role.currentExp) {
            exp = this.role.currentExp;
        }
        NoppesUtilPlayer.sendData(EnumPlayerPacket.CompanionTalentExp, talent.ordinal(), exp);
        this.role.talents.put(talent, this.role.talents.get((Object)talent) + exp);
        this.role.addExp(-exp);
        this.getLabel(this.selected.field_146127_k - 10).setLabel(this.role.talents.get((Object)talent) + "/" + this.role.getNextLevel(talent));
    }

    private void addTalent(int i, EnumCompanionTalent talent) {
        int y = this.guiTop + 28 + i / 2 * 26;
        int x = this.guiLeft + 4 + i % 2 * 84;
        GuiTalent gui = new GuiTalent(this.role, talent, x, y);
        gui.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        this.talents.put(i, gui);
        if (this.role.getTalentLevel(talent) < 5) {
            this.addButton(new GuiNpcButton(i + 10, x + 26, y, 14, 14, "+"));
            y += 8;
        }
        this.addLabel(new GuiNpcLabel(i, this.role.talents.get((Object)talent) + "/" + this.role.getNextLevel(talent), x + 26, y + 8));
    }

    @Override
    public void func_73863_a(int i, int j, float f) {
        super.func_73863_a(i, j, f);
        if (this.selected != null && this.field_146297_k.field_71441_e.func_72820_D() - this.startPressedTime > 4L && this.lastPressedTime < this.field_146297_k.field_71441_e.func_72820_D() && this.field_146297_k.field_71441_e.func_72820_D() % 4L == 0L) {
            if (this.selected.func_146116_c(this.field_146297_k, i, j) && Mouse.isButtonDown((int)0)) {
                this.lastPressedTime = this.field_146297_k.field_71441_e.func_72820_D();
                if (this.lastPressedTime - this.startPressedTime < 20L) {
                    this.addExperience(1);
                } else if (this.lastPressedTime - this.startPressedTime < 40L) {
                    this.addExperience(2);
                } else if (this.lastPressedTime - this.startPressedTime < 60L) {
                    this.addExperience(4);
                } else if (this.lastPressedTime - this.startPressedTime < 90L) {
                    this.addExperience(8);
                } else if (this.lastPressedTime - this.startPressedTime < 140L) {
                    this.addExperience(14);
                } else {
                    this.addExperience(28);
                }
            } else {
                this.lastPressedTime = 0L;
                this.selected = null;
            }
        }
        this.field_146297_k.func_110434_K().func_110577_a(Gui.field_110324_m);
        this.func_73729_b(this.guiLeft + 4, this.guiTop + 20, 10, 64, 162, 5);
        if (this.role.currentExp > 0) {
            float v = 1.0f * (float)this.role.currentExp / (float)this.role.getMaxExp();
            if (v > 1.0f) {
                v = 1.0f;
            }
            this.func_73729_b(this.guiLeft + 4, this.guiTop + 20, 10, 69, (int)(v * 162.0f), 5);
        }
        String s = this.role.currentExp + "\\" + this.role.getMaxExp();
        this.field_146297_k.field_71466_p.func_78276_b(s, this.guiLeft + this.xSize / 2 - this.field_146297_k.field_71466_p.func_78256_a(s) / 2, this.guiTop + 10, CustomNpcResourceListener.DefaultTextColor);
        for (GuiTalent talent : this.talents.values()) {
            talent.func_73863_a(i, j, f);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.talents = new HashMap<Integer, GuiTalent>();
        this.addLabel(new GuiNpcLabel(0, NoppesStringUtils.translate("quest.exp", ": "), this.guiLeft + 4, this.guiTop + 10));
        GuiNpcCompanionStats.addTopMenu(this.role, this, 2);
        int i = 0;
        for (EnumCompanionTalent e : this.role.talents.keySet()) {
            this.addTalent(i++, e);
        }
    }

    public static class GuiTalent
    extends GuiScreen {
        private static final ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/talent.png");
        private final RoleCompanion role;
        private final EnumCompanionTalent talent;
        private final int x;
        private final int y;

        public GuiTalent(RoleCompanion role, EnumCompanionTalent talent, int x, int y) {
            this.talent = talent;
            this.x = x;
            this.y = y;
            this.role = role;
        }

        public void func_73863_a(int i, int j, float f) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(resource);
            ItemStack item = this.talent.item;
            item.func_77973_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            boolean hover = this.x < i && this.x + 24 > i && this.y < j && this.y + 24 > j;
            this.func_73729_b(this.x, this.y, 0, hover ? 24 : 0, 24, 24);
            this.field_73735_i = 100.0f;
            this.field_146296_j.field_77023_b = 100.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179091_B();
            RenderHelper.func_74520_c();
            this.field_146296_j.func_180450_b(item, this.x + 4, this.y + 4);
            this.field_146296_j.func_175030_a(mc.field_71466_p, item, this.x + 4, this.y + 4);
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            this.func_73732_a(mc.field_71466_p, this.role.getTalentLevel(this.talent) + "", this.x + 20, this.y + 16, 0xFFFFFF);
            this.field_146296_j.field_77023_b = 0.0f;
            this.field_73735_i = 0.0f;
            GlStateManager.func_179121_F();
        }
    }
}

